<?php include_once('../config.php') ?>

<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <title>Sisplan Web | Tag</title>
  <!-- Tell the browser to be responsive to screen width -->
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <!-- Font Awesome -->
  <link rel="stylesheet" href="plugins/fontawesome-free/css/all.min.css?versao=3.261.6.2">
  <!-- Theme style -->
  <link rel="stylesheet" href="dist/css/adminlte.min.css?versao=3.261.6.2">
  <!-- Google Font: Source Sans Pro -->
  <!-- <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700" rel="stylesheet"> -->
  <link rel="stylesheet" type="text/css" href="dist/css/dataTables.bootstrap4.min.css?versao=3.261.6.2" />

  <link href='dist/css/bootstrap.min.css?versao=3.261.6.2'>
  <link rel="stylesheet" href="plugins/toastr/toastr.min.css?versao=3.261.6.2">
  <link rel="shortcut icon" href="favicon.ico">
  <link rel="stylesheet" href="dist/css/sisplan.css?versao=3.261.6.2">
  <link rel="stylesheet" href="dist/css/custom.css?versao=3.261.6.2">
  <link rel="stylesheet" type="text/css" href="plugins/datatables-keytable/css/keyTable.bootstrap4.min.css?versao=3.261.6.2">
  <link rel="stylesheet" type="text/css" href="dist/css/driver.min.css?versao=3.261.6.2" />
  <link rel="stylesheet" href="plugins/icheck-bootstrap/icheck-bootstrap.min.css?versao=3.261.6.2">
  <link rel="stylesheet" href="plugins/select2/css/select2.min.css?versao=3.261.6.2">
  <link rel="stylesheet" href="plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css?versao=3.261.6.2">
  <link rel="stylesheet" href="dist/css/PesquisaVariosSelect2.css?versao=3.261.6.2">
  <!-- AutoComplete -->
  <link rel="stylesheet" href="dist/css/jquery-ui.css?versao=3.261.6.2">

  <style>
    .input-group button,
    .input-group input {
      height: 40px;
    }

    .input-group button {
      min-width: 45px;
    }

    .btn.bg-danger {
      border: 1px solid white;
    }

    .info-box-text {
      font-size: 20px;
      font-weight: bold;
      color: grey;
    }

    #cardPrincipal {
      min-height: 400px;
      display: flex;
      justify-content: center;
    }

    .botoes {
      margin-top: 19px !important;
      margin-left: 7px;
    }

    #tabelaTag tbody {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    #tabelaReimprimeTag tbody {
      white-space: nowrap;
      text-overflow: ellipsis;
      overflow: hidden;
    }

    .bordaCampos {
      border: solid #e0e4e6;
      border-radius: 4px;
      border-width: 2px;
      padding-top: 2%;
      padding-bottom: 0%;
    }

    .bordaCampos:first-child {
      display: flex;
      flex-direction: row;
      flex-wrap: wrap;
      justify-content: flex-end;
      align-items: center;
    }

    .border-Field .textoBorda {
      font-size: 1.0em !important;
      text-align: left !important;
      width: auto;
      padding: 0 10px;
      border-bottom: none;
    }

    .border-Field {
      border: 1.0px solid var(--font-color) !important;
      padding: 0 1.0em 1.0em 1.0em !important;
      margin: 0 0 1.0em 0 !important;
      -webkit-box-shadow: 0px 0px 0px 0px #000;
      box-shadow: 0px 0px 0px 0px #000;
      padding-bottom: 0px !important;
    }
  </style>

</head>

<body class="hold-transition sidebar-mini layout-fixed">
  <div class="wrapper">

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
      <!-- Content Header (Page header) -->
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-2">
            <div class="col-sm-6 flex">
              <h1 class="m-0 text-dark">Tag Kit</h1>
              <button type="button" class="btn btn-info btn-sm ml-2" style="color: white;" id="tutorial">
                <i class="fas fa-question-circle"></i>
              </button>
            </div><!-- /.col -->
            <div class="col-sm-6">

            </div><!-- /.col -->
          </div><!-- /.row -->

          <div class="card" id="cardPrincipal">
            <div class="row mx-2 mt-3" id="tourbotoes">
              <div class="col-sm-12 mt-12">
                <div class="row">
                  <div class="col-4">
                    <label data-error="wrong" data-success="right" for="txtProduto">Produto</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtProduto" name="txtProduto" class="form-control" placeholder="Produto">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnProduto" name="btnProduto" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaProduto" name="btnLimpaProduto" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-4">
                    <label data-error="wrong" data-success="right" for="txtTag">Tag</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtTag" name="txtTag" class="form-control" placeholder="Tag">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnTag" name="btnTag" data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaTag" name="btnLimpaTag" type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="col-4">
                    <label data-error="wrong" data-success="right" for="txtNumOF">Num. OF</label>
                    <div class="input-group">
                      <input type="text" class="input-default focus form-control" id="txtNumOF" disabled name="txtNumOF" class="form-control" placeholder="Num. OF">
                      <div class="input-group-append">
                        <button class="btn bg-danger" id="btnNumOF" name="btnNumOF" disabled data-button="absolute" type="button"><i class="m-0 p-0 fas fa-search"></i></button>
                        <button class="btn bg-danger" id="btnLimpaNumOF" name="btnLimpaNumOF" disabled type="button"><i class="m-0 p-0 fas fa-trash"></i></button>
                      </div>
                    </div>
                  </div>
                  <div class="d-flex float-left col-lg-12 col-12 mt-2">
                    <div class="col-12 pl-0 mt-4 pt-1">
                      <button id="btnGerar" class="btn-sisp btn btn-success"><i class="fas fa-cogs"></i> Gerar</button>
                      <button id="btnLimpar" class="ml-1 btn-sisp btn btn-danger"><i class="fas fa-trash"></i> Limpar</button>
                      <button id="btnImprimir" class="ml-1 btn-sisp btn btn-primary"><i class="fas fa-print"></i> Imprimir</button>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="card-body pb-0">
              <div class="card">
                <div class="card-body">
                  <div class="flex w-100 flex-wrap" style="gap: 0.5%">
                    <div style="width: 49.75%">
                      <h5><b>Kits</b></h5>
                      <div class="row pt-2">
                        <div class="col-sm-12 table-responsive">
                          <table id="tabelaKits" class="table table-responsive-sm table-select table-hover" width="100%">
                            <thead>
                            </thead>
                            <tbody>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                    <div style="width: 49.75%">
                      <h5><b>OFs</b></h5>
                      <div class="row pt-2">
                        <div class="col-sm-12 table-responsive">
                          <table id="tabelaOfs" class="table table-responsive-sm table-select table-hover" width="100%">
                            <thead>
                            </thead>
                            <tbody>
                            </tbody>
                          </table>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>

            <div class="card-body pt-0" id="itensTag">
              <div class="card">
                <div class="card-body">
                  <div id="divTabGrade">
                    <div class="row">
                      <div class="col-12">
                        <h5><b>Grade</b></h5>
                      </div>
                    </div>
                    <div class="row pt-2">
                      <div class="col-sm-12 table-responsive">
                        <table id="tabelaGrade" class="table table-responsive-sm table-select table-hover" width="100%">
                          <thead>
                          </thead>
                          <tbody>
                          </tbody>
                        </table>
                      </div>
                    </div>
                  </div>
                  <div class="row">
                    <div class="col-12">
                      <h5><b>Tag</b></h5>
                    </div>
                  </div>
                  <div class="row pt-2">
                    <div class="col-sm-12 table-responsive">
                      <table id="tabelaTag" class="table table-responsive-sm table-select table-hover" width="100%">
                        <thead>
                        </thead>
                        <tbody>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  <button id="btnConsultar" class='btn btn-primary btn-sisp d-none' type='button'><span class="fas fa-search"></span>Consultar </button>

  <?php
  include_once('../../modais.php');
  ?>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
  </div>
  <!-- ./wrapper -->

  <!-- jQuery -->
  <script src="plugins/jquery/jquery.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/jquery.maskMoney.min.js?versao=3.261.6.2"></script>
  <!-- jQuery UI 1.11.4 -->
  <script src="plugins/jquery-ui/jquery-ui.min.js?versao=3.261.6.2"></script>
  <!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
  <script>
    if ($('[type="date"]').prop('type') != 'date') {
      $('[type="date"]').datepicker();
    }
    $.widget.bridge('uibutton', $.ui.button)
  </script>

  <!-- Bootstrap 4 -->
  <script src="plugins/bootstrap/js/bootstrap.bundle.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/sisplan.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="utils/funcoes.js?versao=3.261.6.2"></script>
  <script src="dist/js/adminlte.min.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="dist/js/jquery.dataTables.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="dist/js/loadingoverlay.min.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="dist/js/dataTables.bootstrap4.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/dataTables.keyTable.js?versao=3.261.6.2"></script>
  <script src="dist/js/requisicoes.js?versao=3.261.6.2"></script>
  <script src="utils/cookies.js?versao=3.261.6.2"></script>
  <!-- SweetAlert2 -->
  <script src="plugins/sweetalert2/sweetalert2.min.js?versao=3.261.6.2"></script>
  <script src="plugins/toastr/toastr.min.js?versao=3.261.6.2"></script>
  <script src="dist/js/driver.min.js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="dist/js/sum().js?versao=3.261.6.2"></script>
  <script type="text/javascript" src="config.js?versao=3.261.6.2"></script>
  <script src="plugins/select2/js/select2.full.min.js?versao=3.261.6.2"></script>
  <script>
    $(document).ready(async function() {

      if (getCookie('usuario') == "") {
        window.location.href = `${BASE_URI}/login`;
        return;
      }

      let usuario = getCookie('usuario');
      let empresa = getCookie('empresa');

      ipInterno = IP_INTERNO;
      ipExterno = IP_EXTERNO;
      basicAuth = BASIC_AUTH;

      const temAcesso = await temAcessoTela('RELTAGKIT');
      if (!temAcesso.resultado) {
        toastrAcesso(temAcesso, BASE_URI);
        return;
      }

      sArquivo = `${BASE_URI}/pages/reltagkit/reltagkit.js?versao=3.261.6.2`;
      insereJavaScriptPagina(sArquivo);
    });
  </script>

</body>

</html>